* ANCOVA_fitness.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'ANCOVA for T. dubius fitness';
data fitness;
	input eggs length treat $;
	* Choose y and x variables;
	y = eggs;
	x = length;
	datalines;
290    5.7   DietIG
 99    5.2   DietIG
340    5.5   DietIG
271    4.8   DietIG
200    5.2   DietIG
405    5.2   DietIG
178    5.1   DietIG
 48    5.0   DietIG
146    4.8   DietIG
184    4.9   DietIG
 66    4.6   DietCPW
 93    5.0   DietCPW
  9    5.4   DietCPW
404    5.4   DietCPW
244    5.1   DietCPW
195    4.9   DietCPW
343    5.2   DietCPW
516    5.0   DietCPW
215    4.6   DietCPW
412    5.6   DietCPW
167    4.8   DietCPW
316    5.2   DietCPW
334    5.3   DietCPW
 62    4.7   WildCPW
290    5.0   WildCPW
488    5.8   WildCPW
336    5.2   WildCPW
337    5.8   WildCPW
230    5.0   WildCPW
381    5.3   WildCPW
192    5.5   WildCPW
186    5.3   WildCPW
467    5.2   WildCPW
 59    4.9   WildCPW
323    5.7   WildCPW
291    4.9   WildCPW
164    5.3   WildCPW
142    5.3   WildCPW
269    5.0   WildCPW
329    5.4   WildCPW
235    5.0   WildCPW
;
run;
* Print data set;
proc print data=fitness;
run;
* Plot data and regression line;
proc gplot data=fitness;
	plot y*x=treat / vaxis=axis1 haxis=axis1 legend=legend1;
	symbol1 i=rl v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;	
	legend1 label=(height=2) value=(height=2);
run;
* ANCOVA;
proc glm data=fitness;
	class treat;
	* Model with interaction;
	*model y = treat x treat*x;
	* Model without interaction;
	model y = treat x;
	lsmeans treat / pdiff=all adjust=tukey cl lines;
	output out=resids p=pred r=resid;
run;
goptions reset=all;
title "Diagnostic plots to check ANCOVA assumptions";
* Plot residuals vs. predicted values;
proc gplot data=resids;
	plot resid*pred=1 / vaxis=axis1 haxis=axis1;
	symbol1 v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* Normal quantile plot of residuals;
proc univariate noprint data=resids;
	qqplot resid / normal waxis=3 height=4;
run;
quit;
